/* Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
All rights reserved. */

import java.io.*;
import java.sql.*;
import java.util.Vector;
import oracle.jdbc.OracleDriver;
import oracle.sql.*;

public class LASOracleLoader {
  public LASOracleLoader(){
  }

  private static String computerName = "stacs34.us.oracle.com"; // host
  private static String databaseName = "hello1";                // sid
  private static String portNumber = "59676";                   // port
  private static String driver = "thin";
  private static String schemaName = "scott";                   // user 
  private static String password = "tiger";
  private static String inpfile = "LASFileNames.txt";
  private static String fTable = "base";
  private static String fCol = "pc";
  private static String blkTable = "blktab";
  private static String blkCol = "pc";
  private static Connection connection = null;

     
  /*************************************************************************/
  static private String usage() {
    return "Usage: java LASOracleLoader \n" +
           "-computerName host \n-portNumber port\n" +
           "-databaseName SID \n-driver jdbcDriver[thin:oci]\n" +
           "-schemaName userName\n" +
           "-password password\n" +
           "-lasfilenames inpfile\n";
  }


  /*************************************************************************/
  public static void setConnection() {
    String connectString =
              "jdbc:oracle:" + driver + ":@"
              + "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(HOST="
              +  computerName + ")"
              + "(PROTOCOL=tcp)(PORT="
              + portNumber + ")))"
              + "(CONNECT_DATA=(SID="
              + databaseName + ")))";
                                                                                    
    try {
      DriverManager.registerDriver(new OracleDriver());
      connection = DriverManager.getConnection(
                   connectString, schemaName, password);
    }
    catch (Throwable t)
    {
      System.out.println(t.toString() + ": \n" + t.getMessage() +
                         "Error attempting to connect to database");
    }
  }


  /*************************************************************************/
  public static Connection getConnection() { 
    return connection; 
  }


  /*************************************************************************/
  private static void processCmdLineArgs(String[] args) {                                                                                   
    // process db connection information
    if (args.length > 0) {
      for (int i = 0; i < args.length ;i++) {
        if (args[i].equalsIgnoreCase("-computerName"))
          computerName = args[++i];
        else if ( args[i].equalsIgnoreCase("-portNumber") )
          portNumber = args[++i];
        else if ( args[i].equalsIgnoreCase("-databaseName") )
          databaseName = args[++i];
        else if ( args[i].equalsIgnoreCase("-driver") )
          driver = args[++i];
        else if ( args[i].equalsIgnoreCase("-schemaName") )
          schemaName = args[++i];
        else if ( args[i].equalsIgnoreCase("-password") )
          password = args[++i];
        else if ( args[i].equalsIgnoreCase("-lasfilenames") )
          inpfile = args[++i];
        else if ( args[i].equalsIgnoreCase("-h")) {
          System.out.println(usage());
          System.exit(0);
        }
      }
    }
    else {
      System.out.println("Using default parameters");
    }
      
    setConnection();      
  }


  /*************************************************************************/
  private static void readFileNames(
    String fileNamesFile,
    Vector<String> fileNames)
      throws Exception
  {
    BufferedReader bufr = new BufferedReader(new FileReader(fileNamesFile));
    String fileName = null;
      
    try {
      while ((fileName = bufr.readLine()) != null)
        fileNames.add(fileName);
      //System.out.println(fileNames.size());
      bufr.close();
    }
    catch (IOException e) {
      System.out.println("IO error trying to read filename"); 
      System.exit(1);
    }
  }


  public static void main(String args[]) throws SQLException, IOException, Exception {
    LAS lasToOracle;
    Vector<String> fileNames = new Vector<String>(); 
    String tableName = "lidar_data";
    String tableTableSpace = "";
    String indexTableSpace = "";
    String indexWorkTableSpace = "";
    String srid = "NULL";
    
    processCmdLineArgs(args);
    //System.out.println(args.length +" and "+ args[13]);
    readFileNames(args[13], fileNames);
    //for (int i=0; i< fileNames.size(); i++)
    //  System.out.println("filename: "+fileNames.get(i));
     
    for(int a = 0; a < fileNames.size(); a++) {
      String fileName = fileNames.get(a);
      //System.out.println(fileName);
      lasToOracle = new LAS(fileName,
                            computerName,
                            databaseName,
                            portNumber,
                            schemaName,
                            password,
                            tableName,
                            tableTableSpace,
                            indexTableSpace,
                            indexWorkTableSpace,
                            srid);
    
      lasToOracle.oracleImport();
    }
  }
}
